///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

BOOL CALLBACK TabSecurityDialog(HWND xHandle, UINT xMessage, WPARAM wParam, LPARAM lParam)
{
    static HWND AuthString_hWnd     = NULL;
    static HWND BaseCommKey_hWnd    = NULL;
    static HWND LocalCryptKey_hWnd  = NULL;
    static HWND AdminPassword1_hWnd = NULL;
    static HWND AdminPassword2_hWnd = NULL;

    if(xMessage == WM_INITDIALOG)
    {
        AuthString_hWnd     = GetDlgItem(xHandle, IDC_AUTHSTRING);
        BaseCommKey_hWnd    = GetDlgItem(xHandle, IDC_BASECOMMKEY);

        LocalCryptKey_hWnd  = GetDlgItem(xHandle, IDC_LOCALCRYPTKEY);
        AdminPassword1_hWnd = GetDlgItem(xHandle, IDC_ADMINPASSWORD1);
        AdminPassword2_hWnd = GetDlgItem(xHandle, IDC_ADMINPASSWORD2);


        Set_Text(AuthString_hWnd, gsAuthString);
        Set_Text(BaseCommKey_hWnd, gsBaseCommKey);

        Set_Text(LocalCryptKey_hWnd,  "Not implemented");
        Set_Text(AdminPassword1_hWnd, "Not implemented");
        Set_Text(AdminPassword2_hWnd, "Not implemented");

        return TRUE;
    }

    if(xMessage == WM_NOTIFY)
    {
        LPNMHDR pNMH = (LPNMHDR)lParam;
        if(pNMH->code == PSN_KILLACTIVE)
        {
            return FALSE;
        }
        if(pNMH->code == PSN_APPLY) // Ok
        {
            char lsAuthString[1024 + 1];
            int liAuthStringLen = Get_TextEx(AuthString_hWnd, lsAuthString, 1024);
            if(liAuthStringLen == 0 || liAuthStringLen > 1024)
            {
                MessageBox(xHandle, "You must enter a valid authentication string. Between 1 and 1024 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsBaseCommKey[1024 + 1];
            int liBaseCommKeyLen = Get_TextEx(BaseCommKey_hWnd, lsBaseCommKey, 1024);
            if(liBaseCommKeyLen == 0 || liBaseCommKeyLen > 1024)
            {
                MessageBox(xHandle, "You must enter a valid base comm key. Between 1 and 1024 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsLocalCryptKey[255 + 1];
            int liLocalCryptKeyLen = Get_TextEx(LocalCryptKey_hWnd, lsLocalCryptKey, 255);
            if(liLocalCryptKeyLen == 0 || liLocalCryptKeyLen > 255)
            {
                MessageBox(xHandle, "You must enter a valid local crypt key. Between 1 and 255 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsAdminPassword1[64 + 1];
            int liAdminPassword1Len = Get_TextEx(AdminPassword1_hWnd, lsAdminPassword1, 64);
            if(liAdminPassword1Len == 0 || liAdminPassword1Len > 64)
            {
                MessageBox(xHandle, "You must enter a valid administrators password. Between 1 and 64 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            char lsAdminPassword2[64 + 1];
            int liAdminPassword2Len = Get_TextEx(AdminPassword2_hWnd, lsAdminPassword2, 64);
            if(liAdminPassword2Len == 0 || liAdminPassword2Len > 64)
            {
                MessageBox(xHandle, "You must enter a valid administrators password. Between 1 and 64 characters.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            if(strcmp(lsAdminPassword1, lsAdminPassword2) != 0)
            {
                MessageBox(xHandle, "The administrators passwords do not match.", TitleCaption, 0);
                SetWindowLong(xHandle, DWL_MSGRESULT, PSNRET_INVALID_NOCHANGEPAGE); // Prevent window from closing
                return TRUE;
            }

            strcpy(gsBaseCommKey, lsBaseCommKey);
            strcpy(gsAuthString, lsAuthString);
            strcpy(gsLocalCryptKey, lsLocalCryptKey);
            strcpy(gsAdminPassword, lsAdminPassword1);

            return TRUE;
        }
        if(pNMH->code == PSN_RESET) // Cancel
        {
            return FALSE;
        }
    }

    return FALSE;
}

///////////////////////////////////////////////////////////////////////////////////////////////////////////////////////

